package com.ejie.aa17a.control.informes;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa17a.model.Aa17aDatoHistorico;
import com.ejie.aa17a.model.Aa17aDatoHorario;
import com.ejie.aa17a.model.Aa17aInformeFiltro;
import com.ejie.aa17a.service.iface.Aa17aDatoHistoricoService;
import com.ejie.aa17a.service.iface.Aa17aDatoHorarioService;
import com.ejie.aa17a.utilidades.Aa17aConstantes;
import com.ejie.aa17a.utilidades.Aa17aFuncionesComunes;

/**
 * Aa17aContaminanteController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/informe")
public class Aa17aInformesController {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aInformesController.class);

	private Aa17aDatoHorarioService aa17aDatoHorarioService;
	private Aa17aDatoHistoricoService aa17aDatoHistoricoService;
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Method 'getAll'.
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "datosHorarios", method = RequestMethod.GET)
	public ModelAndView exportarDatos(Model model) {

		return new ModelAndView("informePDF", "model", model);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return ModelAndView
	 * @throws IOException
	 *             e
	 */
	@RequestMapping(value = "datosHorarios", method = RequestMethod.POST)
	public ModelAndView exportarDatos(@ModelAttribute Aa17aInformeFiltro informeFiltro,
								Model model, HttpServletResponse response) throws IOException {
		Aa17aInformesController.logger.info("[POST - exportarDatos] : Exportar datos horarios");

		//vuelco los datos del filtro al bean de datos horarios para realizar la busqueda
		Aa17aDatoHorario filtroDatoHorario = new Aa17aDatoHorario();
		filtroDatoHorario.setIdEstacion(informeFiltro.getIdEstacion());
		filtroDatoHorario.setFechaDato(informeFiltro.getFecha());
		filtroDatoHorario.setListaContaminantes(informeFiltro.getListaContaminantes());

		List<Aa17aDatoHorario> listDatosHorarios = this.aa17aDatoHorarioService.findAll(filtroDatoHorario);

		model.addAttribute("filtro", informeFiltro);
		model.addAttribute("datos", listDatosHorarios);

		model.addAttribute("tipoInforme", Aa17aConstantes.INFORME_DATOS_HORARIOS);

		//si exportamos en formato csv
		if (informeFiltro.getFormato().equals(Aa17aConstantes.EXPORTAR_FORMATO_CSV)) {
			//genero la cadena a rellenar en el csv y genero el fichero
			StringBuilder fileCsv = this.getCsvDatosHorarios(listDatosHorarios, informeFiltro, false);
			response.setContentType("text/csv");
			response.setContentLength(fileCsv.toString().length());
			response.setHeader("Content-Disposition", "attachment; filename=\"" + "datosHorarios.csv" + "\"");
			response.getOutputStream().write(fileCsv.toString().getBytes());
			response.getOutputStream().flush();
			return null;
		}
		else if (informeFiltro.getFormato().equals(Aa17aConstantes.EXPORTAR_FORMATO_EXCEL)) {
			return new ModelAndView("informeExcel", "model", model);
		}
		else {
			return new ModelAndView("informePDF", "model", model);
		}

	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return ModelAndView
	 * @throws IOException
	 *             e
	 */
	@RequestMapping(value = "datosHistorico", method = RequestMethod.POST)
	public ModelAndView exportarDatosHistorico(@ModelAttribute Aa17aInformeFiltro informeFiltro,
								Model model, HttpServletResponse response) throws IOException {
		Aa17aInformesController.logger.info("[POST - exportarDatos] : Exportar datos historicos");

		model.addAttribute("filtro", informeFiltro);

		List<Aa17aDatoHistorico> listDatosHistoricos = null;
		List<Aa17aDatoHorario> listDatosHorarios = null;

		if (informeFiltro.getTipoDatos().equals(Aa17aConstantes.TIPO_DATOS_DIARIOS)) {
			model.addAttribute("tipoInforme", Aa17aConstantes.INFORME_DATOS_HISTORICOS_DIARIO);

			Aa17aDatoHistorico filtroDatoHistorico = new Aa17aDatoHistorico();
			filtroDatoHistorico.setIdEstacion(informeFiltro.getIdEstacion());
			filtroDatoHistorico.setFechaDesde(informeFiltro.getFechaDesde());
			filtroDatoHistorico.setFechaHasta(informeFiltro.getFechaHasta());

			listDatosHistoricos = this.aa17aDatoHistoricoService.listDatosHistoricos(filtroDatoHistorico);

			model.addAttribute("datos", listDatosHistoricos);
			model.addAttribute("tipoInforme", Aa17aConstantes.INFORME_DATOS_HISTORICOS_DIARIO);

		}
		else if (informeFiltro.getTipoDatos().equals(Aa17aConstantes.TIPO_DATOS_HORARIOS)) {

			//vuelco los datos del filtro al bean de datos horarios para realizar la busqueda
			Aa17aDatoHorario filtroDatoHorario = new Aa17aDatoHorario();
			filtroDatoHorario.setIdEstacion(informeFiltro.getIdEstacion());
			filtroDatoHorario.setFechaDesde(informeFiltro.getFechaDesde());
			filtroDatoHorario.setFechaHasta(informeFiltro.getFechaHasta());
			//filtroDatoHorario.setListaContaminantes(informeFiltro.getListaContaminantes());

			listDatosHorarios = this.aa17aDatoHorarioService.findAll(filtroDatoHorario);

			model.addAttribute("datos", listDatosHorarios);
			model.addAttribute("tipoInforme", Aa17aConstantes.INFORME_DATOS_HISTORICOS_HORARIO);
		}

		//si exportamos en formato csv
		if (informeFiltro.getFormato().equals(Aa17aConstantes.EXPORTAR_FORMATO_CSV)) {

			StringBuilder fileCsv = null;
			if (informeFiltro.getTipoDatos().equals(Aa17aConstantes.TIPO_DATOS_DIARIOS)) {
				fileCsv = this.getCsvDatosDiarios(listDatosHistoricos, informeFiltro);
			}
			else {
				//genero la cadena a rellenar en el csv y genero el fichero
				fileCsv = this.getCsvDatosHorarios(listDatosHorarios, informeFiltro, true);
			}

			response.setContentType("text/csv");
			response.setContentLength(fileCsv.toString().length());
			response.setHeader("Content-Disposition", "attachment; filename=\"" + "datosHorarios.csv" + "\"");
			response.getOutputStream().write(fileCsv.toString().getBytes());
			response.getOutputStream().flush();
			return null;
		}
		else if (informeFiltro.getFormato().equals(Aa17aConstantes.EXPORTAR_FORMATO_EXCEL)) {
			return new ModelAndView("informeExcel", "model", model);
		}
		else {
			return new ModelAndView("informePDF", "model", model);
		}

	}

	/**
	 * 
	 * @param listDatosHorarios
	 *            List<Aa17aDatoHorario>
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @param mostrarFecha
	 *            Boolean
	 * @return StringBuilder
	 */
	private StringBuilder getCsvDatosHorarios(List<Aa17aDatoHorario> listDatosHorarios, Aa17aInformeFiltro informeFiltro, Boolean mostrarFecha) {
		StringBuilder fileCsv = new StringBuilder();

		//datos de referencia de la web
		fileCsv.append(this.getLiteral("informe.origenDatos"));
		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);
		fileCsv.append(this.getLiteral("informe.titulo"));

		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);
		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);

		fileCsv.append(this.dibujarCriteriosBusqueda(informeFiltro));

		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);

		//cabecera del informe
		fileCsv.append(this.getLiteral("informe.parametro"));
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		if (mostrarFecha) {
			fileCsv.append(this.getLiteral("informe.fecha"));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		}
		fileCsv.append("1");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("2");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("3");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("4");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("5");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("6");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("7");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("8");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("9");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("10");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("11");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("12");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("13");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("14");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("15");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("16");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("17");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("18");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("19");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("20");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("21");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("22");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("23");
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append("24");

		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);

		//para formatear los decimales con coma (,)
		DecimalFormat df = new DecimalFormat(Aa17aConstantes.FORMAT_BIGDECIMAL);

		for (Aa17aDatoHorario datoHorario : listDatosHorarios) {
			String nombreContaminante = datoHorario.getContaminante().getNombreContaminante() + " (" + datoHorario.getContaminante().getUnidadMedida() + ")";

			fileCsv.append(nombreContaminante);
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			if (mostrarFecha) {
				fileCsv.append(Aa17aFuncionesComunes.formatearFecha(datoHorario.getFechaDato()));
				fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			}
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora01(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora02(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora03(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora04(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora05(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora06(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora07(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora08(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora09(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora10(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora11(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora12(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora13(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora14(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora15(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora16(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora17(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora18(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora19(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora20(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora21(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora22(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora23(), df));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHorario.getValorHora24(), df));

			fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);
		}

		return fileCsv;

	}

	/**
	 * 
	 * @param listDatosDiario
	 *            List<Aa17aDatoHistorico>
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @return StringBuilder
	 */
	private StringBuilder getCsvDatosDiarios(List<Aa17aDatoHistorico> listDatosDiario, Aa17aInformeFiltro informeFiltro) {
		StringBuilder fileCsv = new StringBuilder();

		//datos de referencia de la web
		fileCsv.append(this.getLiteral("informe.origenDatos"));
		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);
		fileCsv.append(this.getLiteral("informe.titulo"));

		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);
		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);

		fileCsv.append(this.dibujarCriteriosBusqueda(informeFiltro));

		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);
		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);

		//cabecera del informe
		fileCsv.append(this.getLiteral("informe.parametro"));
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append(this.getLiteral("informe.fecha"));
		fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
		fileCsv.append(this.getLiteral("informe.datosHitoricos.valor"));

		fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);

		//para formatear los decimales con coma (,)
		DecimalFormat df = new DecimalFormat(Aa17aConstantes.FORMAT_BIGDECIMAL);

		for (Aa17aDatoHistorico datoHistorico : listDatosDiario) {
			String nombreContaminante = datoHistorico.getContaminante().getNombreContaminante().toString() + " (" + datoHistorico.getContaminante().getUnidadMedida().toString() + ")";

			fileCsv.append(nombreContaminante);
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearFecha(datoHistorico.getFechaDato()));
			fileCsv.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			fileCsv.append(Aa17aFuncionesComunes.formatearBigDecimal(datoHistorico.getValorDiario(), df));

			fileCsv.append(Aa17aConstantes.CSV_SALTO_LINEA);
		}

		return fileCsv;

	}

	/**
	 * 
	 * @param informeFiltro
	 *            Aa17aInformeFiltro
	 * @return String
	 */
	private String dibujarCriteriosBusqueda(Aa17aInformeFiltro informeFiltro) {
		StringBuilder criterios = new StringBuilder();

		//Estacion
		if (informeFiltro.getNombreEstacion() != null) {
			criterios.append(this.getLiteral("informe.estacion"));
			criterios.append(": ");
			criterios.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			criterios.append(informeFiltro.getNombreEstacion());
			criterios.append(Aa17aConstantes.CSV_SALTO_LINEA);
		}

		//contaminantes
		if (informeFiltro.getListaNombresContaminantes() != null && informeFiltro.getListaNombresContaminantes().size() > 0) {
			criterios.append(this.getLiteral("informe.parametros"));
			criterios.append(": ");
			criterios.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			for (String nombre : informeFiltro.getListaNombresContaminantes()) {
				criterios.append(" - ");
				criterios.append(nombre);
			}
			criterios.append(Aa17aConstantes.CSV_SALTO_LINEA);
		}

		//Fecha
		if (informeFiltro.getFecha() != null) {
			criterios.append(this.getLiteral("informe.fecha"));
			criterios.append(": ");
			criterios.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			criterios.append(Aa17aFuncionesComunes.formatearFecha(informeFiltro.getFecha(), LocaleContextHolder.getLocale()));
			criterios.append(Aa17aConstantes.CSV_SALTO_LINEA);
		}

		//Fecha Desde y Fecha Hasta
		if (informeFiltro.getFechaDesde() != null || informeFiltro.getFechaHasta() != null) {
			criterios.append(this.getLiteral("informe.fecha"));
			criterios.append(": ");
			criterios.append(Aa17aConstantes.CSV_SEPARADOR_CAMPO);
			if (informeFiltro.getFechaDesde() != null) {
				criterios.append(Aa17aFuncionesComunes.formatearFecha(informeFiltro.getFechaDesde(), LocaleContextHolder.getLocale()));
				criterios.append(" - ");
			}
			if (informeFiltro.getFechaHasta() != null) {
				criterios.append(Aa17aFuncionesComunes.formatearFecha(informeFiltro.getFechaHasta(), LocaleContextHolder.getLocale()));
			}
			criterios.append(Aa17aConstantes.CSV_SALTO_LINEA);
		}

		return criterios.toString();
	}

	/**
	 * @param aa17aDatoHorarioService
	 *            the aa17aDatoHorarioService to set
	 */
	public void setAa17aDatoHorarioService(Aa17aDatoHorarioService aa17aDatoHorarioService) {
		this.aa17aDatoHorarioService = aa17aDatoHorarioService;
	}

	/**
	 * @param aa17aDatoHistoricoService
	 *            the aa17aDatoHistoricoService to set
	 */
	public void setAa17aDatoHistoricoService(Aa17aDatoHistoricoService aa17aDatoHistoricoService) {
		this.aa17aDatoHistoricoService = aa17aDatoHistoricoService;
	}

	/**
	 * @param messageSource
	 *            the messageSource to set
	 */
	public void setMessageSource(ReloadableResourceBundleMessageSource messageSource) {
		this.messageSource = messageSource;
	}

	/**
	 * 
	 * @param key
	 *            String
	 * @return String
	 */
	private String getLiteral(String key) {
		return this.messageSource.getMessage(key, null, LocaleContextHolder.getLocale());
	}

}
